	function R_ZEROS = REFLECTION_ZEROS(G, Z, P)	
	
	%	Computes the reflection zeros from the gain constant, zeros, and poles.
	%	The reflection zeros are assumed to be imaginary, i.e., on the jw-axis.
	% 	First a poor accuracy approach is used to fined estmated of the reflection zeros.
	%	In the second step the zoros are polished using a naive approach.
	%	The accuracy is limited by the function PZ_2_FREQ_S and the accuracy of G, Z, and P.
 
	% 	Toolbox for ANALOG FILTERS USING MATLAB
	
	% 	Author: 			Lars Wanhammar, 2007-07-16
	% 	Modified by: 	 	
	%	Copyright:			by authors - not released for commercial use
	% 	Version:			1	 
	% 	Known bugs:			Poor accuracy in the reflection zeros
	% 	Report bugs to:		Wanhammar@gmail.com
	
	Tol = 10^-4;
	N = length(P);
	Numer = real(ROOTS_2_POLY(Z));
	Numer2 = POLYMULT(Numer, Numer);	% Allways an even polynomial	
	Denum = real(ROOTS_2_POLY(P));
	Denumodd = Denum;
	for j = length(Denum):-2:1
		Denumodd(j) = -Denum(j);
	end	
	Denum2 = -real(POLYMULT(Denum, Denumodd));
	for j = length(Denum2)-1:-2:1
		Denum2(j) = 0;	
	end
	Poly = POLYSUB(Denum2, G^2*Numer2);	% 2N-order polynomial	
	% If N is even => N refelection zeros and if N is odd => N+1 refelection zeros
	roots(Poly);
	for n = N+2:length(Poly)
		Poly(n) = 0;
	end
	roots(Poly); n = 1;
	for j = 1:2:2*N+1
		X(n) = Poly(j); n = n+1;
	end
	ZEROS = imag(sqrt(roots(X)));
	n = 1;
	for j = 1:2:length(ZEROS)
		Wref(n) = ZEROS(j); n = n+1;
	end

	tol = 10^-4;
	for n = 1:length(Wref)
		H = abs(PZ_2_FREQ_S(G, Z, P, Wref(n)));
		for j=1:10000
			DW = (rand(1)-0.5)*tol;
			W = Wref(n) + DW;
			H1 = abs(PZ_2_FREQ_S(G, Z, P, W));
			if H1 > H 
				Wref(n) = W; H = H1;
			end
		end	
	end
	R_ZEROS = Wref;
